package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.qywx.CompanyWxLabelRequestVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxLabelResponseVo;
import com.bizvane.members.facade.vo.qywx.MainIndexResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface CompanyWxLabelSetApiService {


    //中间会员标签设置查询接口
	@RequestMapping(value="/api/companyWxLabel/queryByBrandId",method=RequestMethod.POST)
    ResponseData queryByBrandId(@RequestParam(value="brandId")Long brandId);
    
    //首页列表取6个常用二级分组
    @RequestMapping(value="/api/companyWxLabel/get6MainIndexLabel",method=RequestMethod.POST)
    ResponseData<List<MainIndexResponseVo>> get6MainIndexSecondLabel(@RequestParam(value="brandId")Long brandId,@RequestParam(value="storeId")Long storeId)throws MemberException;
    
    //品牌下所有一级分组
    @RequestMapping(value="/api/companyWxLabel/getAllFirstLevelLabel",method=RequestMethod.POST)
    ResponseData<List<MainIndexResponseVo>> getAllFirstLevelLabel(@RequestParam(value="brandId")Long brandId)throws MemberException;
    
    //一级分组下的所有二级分组
    @RequestMapping(value="/api/companyWxLabel/getSecondLabelByFirstLevelLabel",method=RequestMethod.POST)
    ResponseData<List<MainIndexResponseVo>> getSecondLabelByFirstLevelLabel(@RequestBody CompanyWxLabelRequestVo companyWxLabelRequestVo)throws MemberException;
    
    //查二级分组下的会员
    @RequestMapping(value="/api/companyWxLabel/getLabelMembers",method=RequestMethod.POST)
    ResponseData<CompanyWxLabelResponseVo> getLabelMembers(@RequestBody CompanyWxLabelRequestVo companyWxLabelRequestVo)throws MemberException;
}
