package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;


/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/10.
 */
public interface ExtendPropertyService {
    /**
     * 多条件分页查询（未禁用的）
     * @param pageVo
     * @param extendPropertyModel
     * @return
     * @throws MemberException
     */
    ResponseData<PageInfo<ExtendPropertyModel>> findAll(PageVo pageVo, ExtendPropertyModel extendPropertyModel)throws MemberException;

    /**
     * 根据品牌查询扩展属性
     * @param extendPropertyModel
     * @return
     * @throws MemberException
     */
    ResponseData<List<ExtendPropertyModel>> findExtendPropertyList(ExtendPropertyModel extendPropertyModel)throws MemberException;

    /**
     * 添加扩展属性
     * @param extendPropertyModel
     * @return
     * @throws MemberException
     */
    ResponseData insertExtendProperty(ExtendPropertyModel extendPropertyModel) throws MemberException;

    /**
     * 更新扩展属性
     * @param extendPropertyModel
     * @return
     * @throws MemberException
     */
    ResponseData updateExtendProperty(ExtendPropertyModel extendPropertyModel) throws MemberException;

    /**
     * 删除扩展属性
     * @param extendPropertyModel
     * @return
     * @throws MemberException
     */
    ResponseData delete(ExtendPropertyModel extendPropertyModel) throws MemberException;

    /**
     * 禁用或者启用扩展属性
     * @param extendPropertyModel
     * @return
     * @throws MemberException
     */
    ResponseData forbidAndOpen(ExtendPropertyModel extendPropertyModel) throws MemberException;

    /**
     * 根据主键查询扩展属性（未禁用的）
     * @param extendPropertyModel
     * @return
     * @throws MemberException
     */
    ResponseData<ExtendPropertyModel> findByPrimaryKey(ExtendPropertyModel extendPropertyModel)throws MemberException;

    ResponseData<Integer> deleteExtendProperty(Long developmentId);
}
