package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrGroupTypeModel;
import com.bizvane.members.facade.vo.MbrGroupTypeVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/27 17:14
 * @Description:
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MemberGroupTypeApiService {

    /**
     * 新建分组类型
     *
     * @param mbrGroupTypeModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/addGroupType", method = RequestMethod.POST)
    ResponseData addGroupType(@RequestBody MbrGroupTypeModel mbrGroupTypeModel) throws MemberException;

    /**
     * 查询品牌下所有分组类型
     *
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryGroupTypeList", method = RequestMethod.POST)
    ResponseData queryGroupTypeList() throws MemberException;

    /**
     * 删除分组类型
     *
     * @param mbrGroupTypeModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/deleteGroupType", method = RequestMethod.POST)
    ResponseData deleteGroupType(@RequestBody MbrGroupTypeModel mbrGroupTypeModel) throws MemberException;

    /**
     * 查询会员分组类型详情
     *
     * @param mbrGroupTypeDefId
     * @return
     */
    @RequestMapping(value = "/api/queryGroupTypeInfo", method = RequestMethod.POST)
    ResponseData queryGroupTypeInfo(@RequestParam("mbrGroupTypeDefId") Long mbrGroupTypeDefId);

    /**
     * 编辑会员分组类型
     *
     * @param mbrGroupTypeModel
     * @return
     */
    @RequestMapping(value = "/api/updateGroupType", method = RequestMethod.POST)
    ResponseData updateGroupType(@RequestBody MbrGroupTypeModel mbrGroupTypeModel);

    /**
     * 查询所有分组类别和分组
     *
     * @param brandId
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryAllGroupList", method = RequestMethod.POST)
    ResponseData<List<MbrGroupTypeVo>> queryAllGroupList(@RequestParam(value = "brandId") Long brandId) throws MemberException;
}
