package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/10.
 * 会员扩展属性定义
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_extend_def")
public class ExtendPropertyModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2477756261192890753L;

    @Id
    @ApiModelProperty(value = "扩展属性id", name = "extendDefId")
    private Long extendDefId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long brandId;

    @ApiModelProperty(value = "属性code", name = "propertyCode")
    private String propertyCode;

    @ApiModelProperty(value = "属性名称", name = "propertyName")
    private String propertyName;

    @ApiModelProperty(value = "属性类型（单选，多选，时间，数字，文本）", name = "propertyType")
    private String propertyType;

    @ApiModelProperty(value = "属性选项", name = "propertyOption")
    private String propertyOption;

    @ApiModelProperty(value = "是否可见", name = "visible")
    private String visible;

    @ApiModelProperty(value = "微信端是否可见", name = "wxVisible")
    private String wxVisible;

    @ApiModelProperty(value = "是否允许编辑", name = "edit")
    private String edit;

    @ApiModelProperty(value = "是否是必填的 1非必传,2必传", name = "required")
    private String required;

    @ApiModelProperty(value = "属性备注", name = "detail")
    private String detail;

    @ApiModelProperty(value = "属性排序", name = "sorted")
    private Integer sorted;

    @ApiModelProperty(value = "定义类型:1、基本属性；2、拓展属性", name = "defType")
    private Integer defType;

    @ApiModelProperty(value = "属性状态：0启用 1禁用",name = "status")
    private String status;
}
