package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.LevelRecordModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.MemberCardBindWxRequestVo;
import com.bizvane.members.facade.vo.MemberCardBindWxResponseVo;
import com.bizvane.members.facade.vo.MemberCardInfoRes;
import com.bizvane.members.facade.vo.MemberInfoRes;
import com.bizvane.members.facade.vo.TurnoverWxBindRelationRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @author houkai
 */
public interface MemberCardService {
    /**
     * 查询会员卡基本信息
     *
     * @param brandId
     * @param memberCode
     * @return
     */
    ResponseData<MemberCardInfoRes> queryMemberCardInfo(Long brandId, String memberCode);

    /**
     * 查询会员个人信息详情
     *
     * @param memberCode
     * @return
     */
    ResponseData<MemberInfoRes> queryMemberInfo(String memberCode);

    /**
     * 编辑会员个人信息
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    ResponseData updateMemberInfo(MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 查询会员等级变更记录
     *
     * @param memberCode
     * @return
     */
    ResponseData<List<LevelRecordModel>> queryMemberLevelRecord(String memberCode);

    /**
     * 查询会员卡片信息
     *
     * @param memberCode
     * @return
     */
    ResponseData queryMemberCard(String memberCode);

    /**
     * 更新会员手机号
     *
     * @param updateMemberPhoneRequestModel
     * @return
     */
    ResponseData updateMemberPhone(MemberInfoModel memberInfoModel);
    
    /**
     * 根据会员卡号查询微信绑定关系
     * @return
     */
    ResponseData<MemberCardBindWxResponseVo> queryMemberCardBindWxRelation(MemberCardBindWxRequestVo memberCardBindWxRequestVo);
    
    
    ResponseData<String> turnoverWxBindRelation(TurnoverWxBindRelationRequestVo turnoverWxBindRelationRequestVo)throws MemberException;
}
