package com.bizvane.members.facade.models.qywx;

import javax.persistence.Table;

import com.bizvane.members.facade.es.pojo.qywx.MemberFlag;
import com.bizvane.members.facade.models.BaseModel;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@Table(name = "t_es_mbr_friends")
public class EsMbrFriendsModel extends BaseModel {

	private static final long serialVersionUID = 1L;
	private Long esMbrFriendsId;
	private Long sysCompanyId;
	private Long brandId;
	private Long guideId;
	private String friendsComment;
	private Integer externalType;
	private String externalUserId;
	private String unionId;
	private List<String> unionIdList;
	private String externalName;
	private String headPortraits;
	private String gender;

	private Long storeId;

	@MemberFlag(name = "memberCode")
	private String memberCode;

	@MemberFlag(name = "levelId")
	private Long levelId;

	@MemberFlag(name = "serviceStoreId")
	private Long serviceStoreId;

	@MemberFlag(name = "serviceGuideId")
	private Long serviceGuideId;

	private Integer focus;

	@MemberFlag(name = "phone")
	private String phone;

	@MemberFlag(name = "name")
	private String memberName;

	private Integer friendStatus;

	private Long precedeGuideId;

	/**
	 * 是否专属会员 0：否 1：是
	 */
	private Integer exclusiveFriend;

	/**
	 * 企微账号
	 */
	private String userId;

	/**
	 * 接替企微账号
	 */
	private String newUserId;

	/**
	 * 接替导购线上id
	 */
	private Long newStaffId;
}
