package com.bizvane.members.facade.enums;

public enum FriendsStatusEnum {
    /**
     * 好友状态 正常
     */
    NORMAL(0, "正常"),
    /**
     * 好友状态 离职待分配
     */
    ASSING(1, "离职待分配"),
    /**
     * 好友状态 待确认
     */
    CONFIRM(2, "待确认"),
    /**
     * 好友状态 删除
     */
    DELETE(3, "删除"),

    /**
     * 在职待分配
     */
    ON_JOB_ASSING(4, "在职待分配"),

    /**
     * 已离职
     */
    ASSIGN_CONFIRMED(5, "已离职"),

    /**
     * 在职分配待确认
     */
    ON_JOB_ASSING_CONFIRMED(6, "在职分配待确认");

    private Integer code;

    private String msg;

    FriendsStatusEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(Integer code) {
        for (FriendsStatusEnum type : FriendsStatusEnum.values()) {
            if (code.equals(type.getCode())) {
                return type.getMsg();
            }
        }
        return "";
    }


}
