package com.bizvane.members.facade.service.vg;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.members.facade.models.po.IntegralRechargeRecordPO;
import com.bizvane.members.facade.vo.vg.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * 锦鸿积分流水查询接口
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface VGIntegralRechargeRecordApiService {

    /**
     * 新增积分充值单
     * @param rechargeRecordAddRequestVO
     * @return
     */
    @PostMapping(value = "/api/vg/addIntegralRechargeRecord")
    ResponseData<IntegralRechargeRecordPO> addIntegralRechargeRecord(@RequestBody VGIntegralRechargeRecordAddRequestVO rechargeRecordAddRequestVO);

    /**
     * 根据单号查询积分充值单
     * @param rechargeRecordSearchRequestVO
     * @return
     */
    @PostMapping(value = "/api/vg/queryIntegralRechargeRecordByOrderNo")
    ResponseData<IntegralRechargeRecordPO> queryIntegralRechargeRecordByOrderNo(@RequestBody VGIntegralRechargeRecordSearchRequestVO rechargeRecordSearchRequestVO);


    /**
     * 积分充值但计算金额
     * @param rechargeRecordCalculationRequestVO
     * @return
     */
    @PostMapping(value = "/api/vg/calculationAmount")
    ResponseData<Integer> calculationAmount(@RequestBody VGIntegralRechargeRecordCalculationRequestVO rechargeRecordCalculationRequestVO);


    /**
     * 积分充值支付成功
     * @return
     */
    @PostMapping(value = "/api/vg/paid")
    ResponseData paid(@RequestBody VGIntegralRechargeRecordPaidVO vgIntegralRechargeRecordPaidVO);


    @PostMapping(value = "/api/vg/queryIntegralRecharge")
    ResponseData<PageInfo<IntegralRechargeRecordPO>> queryIntegralRecharge(@RequestBody VGIntegralRechargeRecordSearchRequestVO rechargeRecordAddRequestVO);

    @PostMapping(value = "/api/vg/exportIntegralRecharge")
    ResponseData<String> exportIntegralRecharge(@RequestBody VGIntegralRechargeRecordSearchRequestVO rechargeRecordAddRequestVO, FileTaskPo fileTaskPo) ;
}
