package com.bizvane.members.facade.vo.vg;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BrandMessagesVO {
    //品牌名
    private String brandName;
    //等级
    private String levelName;
    //导购名
    private String guideName;
    //所属店铺名称
    private String storeName;

    private Date createDate;

    //店铺code
    private String storeCode;

    private String erpId;

    //关注时间
    private Date focusTime;
    @ApiModelProperty(value = "是否关注：1未关注，2已关注", name = "memberName")
    private Integer focus;

    @ApiModelProperty(value = "取关时间", name = "unFocusTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date unFocusTime;

    //公众号名称
    private String nickName;

    private Long brandId;

}
