package com.bizvane.members.facade.vo;

import java.io.Serializable;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
public class MemberInfoSimpleVO implements Serializable {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "会员id", name = "mbrMemberId")
  private Long mbrMemberId;

  @ApiModelProperty(value = "会员code", name = "memberCode")
  private String memberCode;
  
  private String groupMemberCode;
  
  @ApiModelProperty(value = "会员线下卡号", name = "offlineCardNo")
  private String offlineCardNo;
  
  private String erpId;
  
  private String cardNo;
  
  @ApiModelProperty(value = "品牌id", name = "brandId")
  private Long brandId;
  
  @ApiModelProperty(value = "企业id", name = "sysCompanyId")
  private Long sysCompanyId;
  
  private String name;
  
  @ApiModelProperty(value = "会员手机号", name = "phone")
  private String phone;
  
  @ApiModelProperty(value = "会员性别", name = "gender")
  private String gender;
  
  @ApiModelProperty(value = "会员身份证号", name = "idCard")
  private String idCard;
  
  @ApiModelProperty(value = "会员生日", name = "birthday")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "Asia/Shanghai")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date birthday;
  
  @ApiModelProperty(value = "开卡导购id", name = "openCardGuideId")
  private Long openCardGuideId;
  
  @ApiModelProperty(value = "开卡门店id", name = "openCardStoreId")
  private Long openCardStoreId;

  @ApiModelProperty(value = "服务门店id", name = "serviceStoreId")
  private Long serviceStoreId;

  @ApiModelProperty(value = "服务导购id", name = "serviceGuideId")
  private Long serviceGuideId;

  @ApiModelProperty(name = "firstOpenBrandCode",value = "首次入会俱乐部code")
  private String firstOpenBrandCode;

}
