package com.bizvane.members.facade.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/15.
 */
@Data
public class MemberInfoCardVo {

    @ApiModelProperty(value = "会员卡号", name = "cardNo")
    private String cardNo;

    @ApiModelProperty(value = "开卡日期", name = "openCardTime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date openCardTime;

    @ApiModelProperty(value = "开卡导购Id", name = "openCardGuideId")
    private Long openCardGuideId;

    @ApiModelProperty(value = "开卡导购名字", name = "openCardGuideName")
    private String openCardGuideName;

    @ApiModelProperty(value = "开卡店铺Id", name = "openCardStoreId")
    private Long openCardStoreId;

    @ApiModelProperty(value = "开卡店铺名称", name = "openCardStoreName")
    private String openCardStoreName;

    @ApiModelProperty(value = "开卡渠道Id", name = "openCardChannelId")
    private Long openCardChannelId;

    @ApiModelProperty(value = "开卡渠道名称", name = "openCardChannelName")
    private String openCardChannelName;

    @ApiModelProperty(value = "会员开卡全部渠道Ids", name = "allChannelIds")
    private String allChannelIds;

    @ApiModelProperty(value = "会员开卡全部渠道", name = "allChannelCard")
    private List <Map> allChannelCard;

    @ApiModelProperty(value = "会员等级", name = "levelName")
    private String levelName;

    @ApiModelProperty(value = "有效期", name = "effectiveTime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date effectiveTime;

    @ApiModelProperty(value = "绑卡日期", name = "bindCardTime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date bindCardTime;


    @ApiModelProperty(value = "所属经销商Id", name = "dealerAttributionId")
    private Long dealerAttributionId;

    @ApiModelProperty(value = "所属经销商名称",name = "dealerAttributionName")
    private String dealerAttributionName;

    @ApiModelProperty(value = "推广渠道", name = "generalizeChannel")
    private String generalizeChannel;
    
    @ApiModelProperty(value="微信绑定状态，1未绑定，2已绑定",name="bindWxStatus")
    private Integer bindWxStatus;
    
    @ApiModelProperty(value="微信wxUnionId",name="wxUnionId")
    private String wxUnionId;
    
    @ApiModelProperty(value="企业品牌",name="brandId")
    private Long brandId;
    
    private String wxOpenId;
    
    @ApiModelProperty(value="微信推广渠道",name="wxGeneralizeChannel")
    private String wxGeneralizeChannel;
    
    @ApiModelProperty(value="充值余额",name="balance")
    private BigDecimal balance;
    
    private WeChatChannelVo weChatChannelVo;
    
    private TaoBaoChannelVo taoBaoChannelVo;
    
    private ElectCardChannelVo electCardChannelVo;

    @ApiModelProperty(value="erpid",name="erpid")
    private String erpid;

    @ApiModelProperty(value="是否是企微好友",name="companyFriend")
    private Boolean companyFriend;

    @ApiModelProperty(value="邀请人名称",name="InviterMemberName")
    private String InviterMemberName;

    @ApiModelProperty(value="邀请人手机",name="InviterMemberPhone")
    private String InviterMemberPhone;


    private String phone;

    private String name;

    @ApiModelProperty(value = "开卡店铺code", name = "openCardStoreCode")
    private String openCardStoreCode;

    
}
