package com.bizvane.members.facade.service.inner;

import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.vo.DistributionMemberVo;
import com.bizvane.members.facade.vo.DownTotalRecordVO;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/28.
 */
@Service
public interface DataExportService {


    /**
     * 导出扩展属性列表
     * @param extendPropertyModel
     * @return
     */
    @Deprecated
    public ResponseData<String> exportExtendPropertyList(FileTaskPo fileTaskPo, ExtendPropertyModel extendPropertyModel) throws MemberException;


    /**
     * 导出分销会员信息列表
     * @param distributionMemberVo
     * @return
     * @throws MemberException
     */
    public ResponseData<String> exportDistributionMemberInfoList(FileTaskPo fileTaskPo, DistributionMemberVo distributionMemberVo) throws MemberException;

    /**
     * 导出个人会员积分
     * @param fileTaskPo
     * @param integralRecordVo
     * @return
     */
    ResponseData<String> exportMemberPersonalIntegralList(FileTaskPo fileTaskPo, IntegralRecordVo integralRecordVo);

    /**
     * 导出个人消费记录
     * @param fileTaskPo
     * @param map
     * @return
     */
    ResponseData<String> exportMemberPersonalConsumeList(FileTaskPo fileTaskPo, Map map);

    /**
     * 导出会员降级记录
     * @param fileTaskPo
     * @param downTotalRecordVO
     * @return
     * @throws MemberException
     */
    @Deprecated
    public ResponseData<String> exportUpDownMemberGradeRecoredList(FileTaskPo fileTaskPo, DownTotalRecordVO downTotalRecordVO) throws MemberException;

    }
