package com.bizvane.members.facade.service.inner;

import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.BatchTaskBo;
import com.bizvane.members.facade.vo.*;
import com.bizvane.members.facade.vo.qywx.StaffHandleVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;
import java.util.Map;

public interface MemberInfoService {
    /**
     * 多条件分页查询（未禁用的）
     *
     * @param pageVo
     * @param map
     * @return
     * @throws MemberException
     */
    ResponseData<PageInfo<MemberInfoVo>> findAllByConditions(PageVo pageVo, Map map) throws MemberException;

    /**
     * 查询扩展属性列 列表  启用的
     *
     * @param brandId
     * @return
     */
    public ResponseData queryExtendPropertyColumn(Long brandId) throws MemberException;

    /**
     * 根据主键查询扩展属性（未禁用的）
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    ResponseData<MemberInfoModel> findByMemberCode(MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 手动调整积分
     *
     * @param integralRecordModel
     * @return
     * @throws MemberException
     */
    ResponseData<Integer> manualChangeMemberIntegral(IntegralRecordModel integralRecordModel) throws MemberException;

    /**
     * 批量贴标签
     *
     * @param map
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateMemberLabel(List<String> membersCode, List<String> labelIds, List<String> labelNames, Map map, Integer type) throws MemberException;



    ResponseData<BatchTaskBo> batchUpdateMemberLabelTask(BatchMemberTaskVo batchMemberTaskVo, SysAccountPO sysAccountPo);


    void asyncBatchMemberLabelTask(BatchMemberTaskVo batchMemberTaskVo, BatchTaskBo batchTaskBo);


    void asyncRetryMemberLabelTask(BatchTaskBo batchTaskBo);


    /**
     * 批量修改服务门店
     *
     * @param batchUpdateMemberInfoVo
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateServiceStore(BatchUpdateMemberInfoVo batchUpdateMemberInfoVo) throws MemberException;

    /**
     * 批量修改服务导购
     *
     * @param batchUpdateMemberInfoVo
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateServiceGuide(BatchUpdateMemberInfoVo batchUpdateMemberInfoVo) throws MemberException;

    /**
     * 批量修改服务门店和导购
     *
     * @param batchUpdateMemberInfoVo
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateServiceStoreAndGuide(BatchUpdateMemberInfoVo batchUpdateMemberInfoVo) throws MemberException;


    ResponseData<BatchTaskBo> batchUpdateServiceStoreAndGuideTask(BatchMemberTaskVo batchMemberTaskVo, SysAccountPO sysAccountPo);


    void asyncBatchStoreAndGuideTask(BatchMemberTaskVo batchMemberTaskVo, BatchTaskBo batchTaskBo);


    void asyncRetryStoreAndGuideTask(BatchTaskBo batchTaskBo);

    /**
     * 查询店铺信息
     *
     * @param sysStoreVO
     * @return
     * @throws MemberException
     */
    ResponseData<com.github.pagehelper.PageInfo<SysStoreVo>> findServiceStore(SysStoreVo sysStoreVO) throws MemberException;

    /**
     * 查询导购信息
     *
     * @param staffVO
     * @return
     * @throws MemberException
     */
    ResponseData<PageInfo<StaffVo>> findServiceGuide(StaffVo staffVO) throws MemberException;

    /**
     * 调整等级
     *
     * @param levelRecordVo
     * @return
     * @throws MemberException
     */
    ResponseData changeMemberLevel(LevelRecordVo levelRecordVo) throws MemberException;

    /**
     * 查询分销会员列表
     *
     * @param pageVo
     * @return
     */
    ResponseData<com.github.pagehelper.PageInfo<MemberInfoModel>> findDistributionMemberList(PageVo pageVo, DistributionMemberVo distributionMemberVo);

    /**
     * 启用禁用分销状态
     *
     * @param memberInfoModel
     * @return
     */
    ResponseData updateDistributionState(MemberInfoModel memberInfoModel);

    /**
     * 根据会员code查询会员积分
     *
     * @param memberCode
     * @return
     */
    ResponseData getIntegralByMemberCode(String memberCode);


    /**
     * 根据会员code查询会员等级
     *
     * @param memberCode
     * @return
     */
    ResponseData getLevelByMemberCode(String memberCode);

    /**
     * 获取服务门店名称
     *
     * @return
     */
    String getMemberServiceStoreName(Long id);

    /**
     * 通过storeId获取服务门店名称
     *
     * @return
     */
    String getMemberServiceStoreNameByStoreId(String id, Long sysBrandId, Long sysCompanyId);

    /**
     * 获取服务导购名称
     *
     * @param id
     * @return
     */
    String getMemberServiceGuideName(Long id);

    /**
     * 查询标签组和标签列表
     *
     * @param brandId
     * @return
     */
    ResponseData queryLabelList(Long brandId);

    /**
     * 手动分页查询 导出相关
     *
     * @param limit
     * @param to
     * @return
     */
    List<MemberInfoModel> getMemberInfoWithLimitTo(Long limit, Long to);


    public int updateLabels(MemberInfoModel memberInfoModel, List<String> labelIds, List<String> labelNames, Map map);

    ResponseData<MemberInfoModel> findByMemberCodeList(List<String> memberCodeList, Long sysCompanyId, Long sysBrandId);


    ResponseData<String> staffHandle(StaffHandleVo staffHandleVo);

    /**
     * 361更新会员服务门店到线下
     *
     * @param memberInfoModel   需要phone、cardNo、brandId
     * @param orderSapStoreCode
     */
    int updateMemberServiceStore361Offline(MemberInfoModel memberInfoModel, String orderSapStoreCode);

    /**
     * 更新会员服务门店到线下
     *
     * @param member
     * @param offlineStoreCode
     * @return
     */
    void updateMemberServiceStoreOffline(MemberInfoModel member, String offlineStoreCode);


    /**
     * 361首单服务门店处理，如果服务门店是默认的虚拟门店，则更换成订单的门店,如果服务门店是默认的虚拟导购，则更换成订单的导购
     * @param member
     * @param storeCode
     * @param orderServiceGuideSysStaffIdList
     */
    boolean firstOrderUpdateServiceStore361AndServiceGuide(MemberInfoModel member, String storeCode, List<Long> orderServiceGuideSysStaffIdList);


    /**
     * 首单服务门店处理，如果服务门店是默认的虚拟门店，则更换成订单的门店
     *
     * @param memberInfoModel       会员信息，包含membercode、当前服务门店serviceStoreId、公司id、品牌id、erpid、offlineCardNo
     * @param orderServiceStoreCode 订单上的线下门店code
     * @return
     */
    boolean firstOrderUpdateServiceStore(MemberInfoModel memberInfoModel, String orderServiceStoreCode);

    /**
     * 首单服务门店处理，如果服务门店是默认的虚拟门店，则更换成订单的门店,如果服务门店是默认的虚拟导购，则更换成订单的导购
     *
     * @param memberInfoModel       会员信息，包含membercode、当前服务门店serviceStoreId、公司id、品牌id、erpid、offlineCardNo
     * @param orderServiceStoreCode 订单上的线下门店code
     * @param orderServiceGuideCodeList 订单上的多个导购code拼接
     * @param serviceGuideType 导购数据类型,0:guideCode,1:staffId
     * @return
     */
    boolean firstOrderUpdateServiceStoreAndGuide(MemberInfoModel memberInfoModel, String orderServiceStoreCode, List<String> orderServiceGuideCodeList, int serviceGuideType);


    boolean firstOrderUpdateServiceStore(MemberInfoModel memberInfoModel, Long orderServiceStoreId);

    /**
     * 线上线下更新会员服务门店
     *
     * @param memberInfoModel
     */
    void updateMemberServiceStoreAllWay(MemberInfoModel memberInfoModel);

    /**
     * 根据erpid查询会员信息
     *
     * @param erpId
     * @param companyId
     * @param brandId
     * @return
     */
    MemberInfoModel findByErpId(String erpId, Long companyId, Long brandId);

    /**
     * 根据memberCode更新会员等级
     *
     * @param memberCode
     * @param newLevelId
     * @param newLevelCode
     * @return
     */
    void updateMemberLevelByMemberCode(String memberCode, Long newLevelId, String newLevelCode);

    /**
     * 更新361会员线下等级
     *
     * @param erpId
     * @param cardNo
     * @param phone
     * @param brandId
     * @param levelCode
     */
    void updateMemberLevelOffline361(String erpId, String cardNo, String phone, Long brandId, String levelCode);

    /**
     * 更新会员等级信息写入es
     *
     * @param memberCode
     * @param newLevelId
     * @param newLevelCode
     * @param companyId
     * @param brandId
     */
    void updateMemberLevelToEs(String memberCode, Long newLevelId, String newLevelCode, Long companyId, Long brandId);

    /**
     * 更新会员线下等级
     *
     * @param erpId
     * @param cardNo
     * @param phone
     * @param newLevelCode
     * @param brandId
     */
    void updateMemberLevelOffline(String erpId, String cardNo, String phone, String newLevelCode, Long brandId);

    /**
     * 导出由excel导入的会员
     *
     * @param infoImportVo
     * @param currentUser
     * @return
     */
    ResponseData<String> exportMemberInfoImport(MemberInfoImportVo infoImportVo, SysAccountPO currentUser);

    /**
     * 批量修改会员状态
     *
     * @param batchUpdateMemberInfoVo
     * @return
     * @throws MemberException
     */
    ResponseData batchUpdateMemberValid(BatchUpdateMemberInfoVo batchUpdateMemberInfoVo) throws MemberException;


    ResponseData<BatchTaskBo> batchUpdateMemberValidTask(BatchMemberTaskVo batchMemberTaskVo, SysAccountPO sysAccountPo);


    void asyncBatchMemberValidTask(BatchMemberTaskVo batchMemberTaskVo, BatchTaskBo batchTaskBo);


    void asyncRetryMemberValidTask(BatchTaskBo batchTaskBo);


    //积分获取开关
    ResponseData<String> integralSwitch(BatchSwitchVO batchSwitchVO);


    //成长值获取开关
    ResponseData<String> growthSwitch(BatchSwitchVO batchSwitchVO);

    /**
     * 查询Qa标签列表
     *
     * @param vo
     * @return
     */
    ResponseData queryQaLabelList(QaAudienceLabelTypeiVo vo);

    ResponseData deleteTestMember(String phones, Long brandId);
}
