package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.es.pojo.BasicMembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.GroupAbilityMembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.GroupMixMembersInfoSearchVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.GroupAnalyzeSearchVo;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.members.facade.es.pojo.MembersGroupAnalyzePojo;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.MembersGroupAnalyzeSearchVo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.validation.Valid;

/**
 * Created by Administrator on 2018\8\22 0022.
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MembersAdvancedSearchApiService {

    @RequestMapping(value = "/api/memberInfo/queryMemberInfoList", method = RequestMethod.POST)
    ResponseData<PageInfo<MemberInfoVo>> search(@RequestBody MembersInfoSearchVo membersInfoSearchVo);

    @RequestMapping(value = "/api/memberInfo/queryAdvancedMemberInfoList", method = RequestMethod.POST)
    ResponseData<PageInfo<MembersInfoSearchPojo>> advancedSearch(@RequestBody MembersInfoSearchVo membersInfoSearchVo);
    
    @RequestMapping(value = "/api/memberInfo/queryAdvancedSimpleMemberInfoList", method = RequestMethod.POST)
    ResponseData<PageInfo<MemberInfoSimpleVO>> advancedSimpleSearch(@RequestBody MembersInfoSearchVo membersInfoSearchVo);
    
    @RequestMapping(value = "/api/memberInfo/queryvgAdvancedSimpleMemberInfoList", method = RequestMethod.POST)
    ResponseData<PageInfo<MemberInfoSimpleVO>> vgAdvancedSimpleSearch(@RequestBody MembersInfoSearchVo membersInfoSearchVo);
    
    @RequestMapping(value = "/api/memberInfo/queryvgAdvancedMemberInfoList", method = RequestMethod.POST)
    ResponseData<PageInfo<MembersInfoSearchPojo>> vgAdvancedSearch(@RequestBody MembersInfoSearchVo membersInfoSearchVo);

    @RequestMapping(value = "/api/memberInfo/searchGroupAnalyze", method = RequestMethod.POST)
    ResponseData<PageInfo<BasicMembersInfoSearchPojo>> searchGroupAnalyze(@RequestBody GroupAnalyzeSearchVo groupAnalyzeSearchVo);

    /**
     * 有分组能力的高级搜索
     *
     * @param groupAbilityMembersInfoSearchVo
     * @return
     */
    @RequestMapping(value = "/api/memberInfo/groupAbilitlyAdvancedSearch", method = RequestMethod.POST)
    ResponseData<PageInfo<MembersInfoSearchPojo>> groupAbilitlyAdvancedSearch(@RequestBody GroupAbilityMembersInfoSearchVo groupAbilityMembersInfoSearchVo);



    @RequestMapping(value = "/api/memberInfo/groupMixAdvancedSearch", method = RequestMethod.POST)
    ResponseData<PageInfo<MemberInfoModel>> groupMixAdvancedSearch(@RequestBody @Valid GroupMixMembersInfoSearchVo groupMixMembersInfoSearchVo);


    @RequestMapping(value = "/api/memberInfo/searchBasicMemberInfo", method = RequestMethod.POST)
    ResponseData<PageInfo<BasicMembersInfoSearchPojo>> searchBasicMemberInfo(@RequestBody MembersInfoSearchVo membersInfoSearchVo);
}
