/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.vo.MbrLevelCalcIntegralRequestVo;
import com.bizvane.members.facade.vo.MbrLevelCalcIntegralResponseVo;
import com.bizvane.members.facade.vo.PayLevelCardRequestVO;
import com.bizvane.members.facade.vo.PayLevelCardResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${feign.client.members.name}", path="${feign.client.members.path}")
public interface MemberLevelApiService {
    @RequestMapping(value={"/api/queryLevelList"}, method={RequestMethod.POST})
    public List<MbrLevelModel> queryLevelList(@RequestParam(value="brandId") Long var1) throws MemberException;

    @RequestMapping(value={"/api/queryAllLevelList"}, method={RequestMethod.POST})
    public ResponseData<List<MbrLevelModel>> queryAllLevelList(@RequestParam(value="brandId") Long var1) throws MemberException;

    @RequestMapping(value={"/api/queryOnLevel"}, method={RequestMethod.POST})
    public ResponseData<MbrLevelModel> queryOnLevel(@RequestParam(value="mbrLevelId") Long var1) throws MemberException;

    @RequestMapping(value={"/api/queryLevelModel"}, method={RequestMethod.POST})
    public ResponseData<MbrLevelModel> queryLevelModel(@RequestParam(value="mbrLevelId") Long var1) throws MemberException;

    @RequestMapping(value={"/api/queryLevelIdByCode"}, method={RequestMethod.POST})
    public ResponseData<MbrLevelModel> queryLevelIdByCode(@RequestBody MbrLevelModel var1) throws MemberException;

    @RequestMapping(value={"/api/updateLevel"}, method={RequestMethod.POST})
    public ResponseData updateLevel(@RequestBody MbrLevelModel var1) throws MemberException;

    @RequestMapping(value={"/api/queryMemberSys"}, method={RequestMethod.POST})
    public ResponseData<MembersSysModel> queryMemberSys(@RequestParam(value="brandId") Long var1);

    @RequestMapping(value={"/api/queryMbrLevelCalcIntegral"}, method={RequestMethod.POST})
    public ResponseData<MbrLevelCalcIntegralResponseVo> queryMbrLevelCalcIntegral(@RequestBody @Valid MbrLevelCalcIntegralRequestVo var1);

    @RequestMapping(value={"/api/queryLevelIdByOfflineCode"}, method={RequestMethod.POST})
    public ResponseData<Long> queryLevelIdByOfflineCode(@RequestParam(value="offlineLevelCode") String var1, @RequestParam(value="brandId") Long var2);

    @RequestMapping(value={"/api/queryPayLevelCard"}, method={RequestMethod.POST})
    public ResponseData<PayLevelCardResponseVO> queryPayLevelCard(@RequestBody @Valid PayLevelCardRequestVO var1);

    @RequestMapping(value={"/api/judgePayLevelCard"}, method={RequestMethod.POST})
    public ResponseData<Boolean> judgePayLevelCard(@RequestParam(value="sysCompanyId") Long var1, @RequestParam(value="brandId") Long var2);
}

