/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.service.datafetch.process;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;

public abstract class BaseFetchData<T, V> {
    private static final Logger log = LoggerFactory.getLogger(BaseFetchData.class);

    public final void dataFetch(String message, String topic) {
        log.info("enter MemberDataFetch messageBody:{} " + message);
        T t = this.messageToBean(message);
        if (t == null) {
            log.error("\u7c7b\u8f6c\u6362\u5f02\u5e38,\u5bf9\u8c61\u4e3anull!");
            return;
        }
        ResponseData messageResponseData = this.verifyMessage(t, topic);
        if (SysResponseEnum.FAILED.getCode() == messageResponseData.getCode()) {
            return;
        }
        ResponseData<V> responseData = this.paramValidation(t, topic);
        if (SysResponseEnum.FAILED.getCode() == responseData.getCode()) {
            log.info("\u9a8c\u8bc1\u975e\u7a7a\u5b57\u6bb5\u51fa\u9519!");
            log.error(responseData.getMessage());
            return;
        }
        Object newObj = responseData.getData();
        if (newObj == null) {
            return;
        }
        V original = this.messageIsExist(t);
        if (original == null) {
            try {
                this.insertData(newObj, topic);
            }
            catch (DuplicateKeyException e) {
                original = this.messageIsExist(t);
                this.abnormalUpdateData(newObj, original, topic, t);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.updateData(newObj, original, topic);
        }
    }

    public abstract T messageToBean(String var1);

    public abstract ResponseData verifyMessage(T var1, String var2);

    public abstract ResponseData<V> paramValidation(T var1, String var2);

    public abstract V messageIsExist(T var1);

    public abstract int insertData(V var1, String var2);

    public abstract int updateData(V var1, V var2, String var3);

    public abstract int abnormalUpdateData(V var1, V var2, String var3, T var4);
}

