/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.enums.CardStatusEnum;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiOpenCardServiceAbstract<P, H> {
    private static final Logger log = LoggerFactory.getLogger(ApiOpenCardServiceAbstract.class);

    public ResponseOpenCardModel openCardProcess(RequestOpenCardModel requestOpenCardModel) throws MemberException {
        this.validationData(requestOpenCardModel);
        ResponseOpenCardModel responseOpenCardModel = this.invokeOnlineMemberProcess(requestOpenCardModel);
        if (SysResponseEnum.SUCCESS.getCode() == responseOpenCardModel.getCode().intValue()) {
            requestOpenCardModel.setIsExist(true);
            if (this.isBandingCard(responseOpenCardModel)) {
                log.info("\u7ebf\u4e0a\u5b58\u5728\u8be5\u4f1a\u5458\u4fe1\u606f\uff0c\u5e76\u5df2\u5f00\u5361");
                return responseOpenCardModel;
            }
            log.info("\u7ebf\u4e0a\u5b58\u5728\u8be5\u4f1a\u5458\u4fe1\u606f\uff0c\u4f46\u672a\u5f00\u5361");
        }
        log.info("\u7ebf\u4e0a\u4e0d\u5b58\u5728\u4f1a\u5458,\u6216\u8005\u7ebf\u4e0a\u4f1a\u5458\u672a\u7ed1\u5361\uff0c\u8c03\u7528\u7ebf\u4e0b\u767b\u5f55\uff01");
        responseOpenCardModel = this.invokeOfflineLoginProcess(requestOpenCardModel);
        if (this.resultResponseOpenCard(responseOpenCardModel)) {
            return responseOpenCardModel;
        }
        log.info("\u7ebf\u4e0b\u4e0d\u5b58\u5728,\u8c03\u7528\u7ebf\u4e0b\u6ce8\u518c\uff01");
        responseOpenCardModel = this.invokeOfflineRegisterProcess(requestOpenCardModel);
        if (this.resultResponseOpenCard(responseOpenCardModel)) {
            return responseOpenCardModel;
        }
        return null;
    }

    private boolean resultResponseOpenCard(ResponseOpenCardModel responseOpenCardModel) {
        if (SysResponseEnum.SUCCESS.getCode() == responseOpenCardModel.getCode().intValue()) {
            this.asyncProcessMessage(responseOpenCardModel);
            return true;
        }
        return false;
    }

    private void asyncProcessMessage(ResponseOpenCardModel instance) {
        new Thread(() -> this.notifyActivityTaskAndSendMessage(instance)).start();
    }

    public boolean isBandingCard(ResponseOpenCardModel responseOpenCardModel) {
        return CardStatusEnum.ALREADY_BIND_CARD.getCode().equals(responseOpenCardModel.getCardStatus());
    }

    public abstract void validationData(RequestOpenCardModel var1) throws MemberException;

    public abstract ResponseOpenCardModel invokeOnlineMemberProcess(RequestOpenCardModel var1) throws MemberException;

    public abstract ResponseOpenCardModel invokeOfflineLoginProcess(RequestOpenCardModel var1) throws MemberException;

    public abstract ResponseOpenCardModel invokeOfflineRegisterProcess(RequestOpenCardModel var1) throws MemberException;

    protected abstract void notifyActivityTaskAndSendMessage(ResponseOpenCardModel var1) throws MemberException;
}

