/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.config;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class DateConvert
implements Converter<String, Date> {
    private static final Logger log = LoggerFactory.getLogger(DateConvert.class);
    private static final List<String> FORMARTS = new ArrayList<String>();

    public Date convert(String source) {
        String value = source.trim();
        log.info("DateConvert#convert value:{}", (Object)value);
        if ("".equals(value)) {
            return null;
        }
        if (source.matches("^\\d{4}-\\d{1,2}$")) {
            return this.parseDate(source, FORMARTS.get(0));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
            return this.parseDate(source, FORMARTS.get(1));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}$")) {
            return this.parseDate(source, FORMARTS.get(2));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            return this.parseDate(source, FORMARTS.get(3));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
            return this.parseDate(source, FORMARTS.get(4));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,3}Z$")) {
            return this.parseDate(source, FORMARTS.get(5));
        }
        LocalDateTime date = LocalDateTime.parse(source.substring(0, source.indexOf("+")), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        return Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }

    Date parseDate(String dateStr, String format) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            date = dateFormat.parse(dateStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static void main(String[] args) throws ParseException {
        String dateStr = "2020-04-03T16:00:00.000Z";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        Date parse = dateFormat.parse(dateStr);
        System.out.println(parse);
        if (dateStr.matches("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,3}Z$")) {
            System.out.println("true");
        }
    }

    static {
        FORMARTS.add("yyyy-MM");
        FORMARTS.add("yyyy-MM-dd");
        FORMARTS.add("yyyy-MM-dd HH");
        FORMARTS.add("yyyy-MM-dd HH:mm");
        FORMARTS.add("yyyy-MM-dd HH:mm:ss");
        FORMARTS.add("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    }
}

