package com.bizvane.airport.mall.feign.model.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

@Getter
@Setter
@ApiModel(description = "积分商城商户")
public class IntegralMallMerchantDetailRes implements Serializable {

    @ApiModelProperty("积分商城商户code")
    private String integralMallMerchantCode;

    @ApiModelProperty("商户编码")
    private String integralMallMerchantNo;

    @ApiModelProperty("商户名称")
    private String integralMallMerchantName;

    @ApiModelProperty("状态：0=启用；1=禁用")
    private Integer status;

    @ApiModelProperty("联系电话")
    private String phone;

    @ApiModelProperty("主体名称")
    private String principalName;

    @ApiModelProperty("统一社会信息代码")
    private String unifiedSocialInformationCode;

    @ApiModelProperty("收款账号")
    private String accountNumber;

    @ApiModelProperty("开户行")
    private String openingBank;

    @ApiModelProperty("公共字段：创建日期，下单时间")
    private LocalDateTime createDate;

    @ApiModelProperty("公共字段：创建人编码")
    private String createUserCode;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("修改日期")
    private LocalDateTime modifiedDate;

    @ApiModelProperty("修改人编码")
    private String modifiedUserCode;

    @ApiModelProperty("修改人名称")
    private String modifiedUserName;
}
