package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.enumutils.IntegralMallProductTypeEnum;
import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Getter
@Setter
@ApiModel(description = "积分商城订单")
public class IntegralMallOrderCheckExchangeReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotBlank(message = "会员系统编号code不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("会员系统编号code")
    private String mbrMemberCode;

    @NotBlank(message = "会员openid不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("会员openid")
    private String mbrOpenid;

    @ApiModelProperty("商品类型 1优惠券 2实物")
    @NotBlank(message = "商品类型不能为空", groups = {CreateValidation.class})
    private Integer productType;

    @ApiModelProperty("积分商品系统编号code")
    @NotBlank(message = "积分商品系统编号code不能为空", groups = {CreateValidation.class})
    private String integralProductCode;

    @ApiModelProperty("兑换数量")
    @NotBlank(message = "兑换数量不能为空", groups = {CreateValidation.class})
    private Integer exchangeNum;

    @ApiModelProperty("积分商品sku系统编码")
    private String integralProductSkuCode;

    @AssertTrue(message = "积分商品sku系统编码不能为空", groups = {CreateValidation.class})
    public boolean checkIntegralProductSkuCode() {
        return IntegralMallProductTypeEnum.INTEGRAL_PRODUCT.getType().equals(productType) ? StringUtils.isNotBlank(integralProductSkuCode) : true;
    }

}
