package com.bizvane.airport.mall.feign.model.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 积分商品
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商品")
public class IntegralProductPageRes implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统code")
    private String integralProductCode;

    @ApiModelProperty("所属机构编号")
    private String airportNoOrg;

    @ApiModelProperty("商品分类系统code")
    private String productCategoryCode;

    @ApiModelProperty("商品编码")
    private String productNo;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品主图")
    private String productMainImg;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    private Integer payType;

    @ApiModelProperty("积分价格")
    private Integer integralPrice;

    @ApiModelProperty("现金价格 单位元")
    private BigDecimal cashPrice;

    @ApiModelProperty("商品成本 单位元")
    private BigDecimal costPrice;

    @ApiModelProperty("每人限兑数量")
    private Integer countPerLimit;

    @ApiModelProperty("库存数量")
    private Integer stockNum;

    @ApiModelProperty("虚拟兑换数量")
    private Integer virtualExchangeNum;

    @ApiModelProperty("剩余数量")
    private Integer remainNum;

    @ApiModelProperty("实兑数量")
    private Integer realExchangeNum;

    @ApiModelProperty("占单数量")
    private Integer holdOrderNum;

    @ApiModelProperty("适用会员范围类型 1全部会员 2会员等级")
    private Integer memberRangeType;

    @ApiModelProperty("会员等级code，逗号拼接")
    private String memberLevelCode;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("是否热门 0否1是")
    private Boolean hotState;

    @ApiModelProperty("商品类型 1优惠券 2实物")
    private Integer productType;

    @ApiModelProperty("优惠券商品类型 0无需配置 1普通优惠券")
    private Integer productCouponType;

    @ApiModelProperty("优惠券商品定义系统code, 多个逗号隔开")
    private String productCouponCode;

    @ApiModelProperty("状态 0下架 1上架")
    private Boolean state;

    @ApiModelProperty("定时上架时间")
    private LocalDateTime upFixedTime;

    @ApiModelProperty("定时下架时间")
    private LocalDateTime downFixedTime;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人姓名")
    private String createUserName;

    @ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty("商品规格")
    private List<IntegralProductSkuRes> skuList;

}
