package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 积分商城规格类型
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Data
@ApiModel(description = "积分商城规格类型")
public class IntegralProductSpecChildrenReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号code")
    private String integralProductSpecCode;

    @NotBlank(message = "规格编号不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("规格名称")
    private String specName;

    @NotNull(message = "有效无效不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("有效无效")
    private Boolean valid;

    @AssertTrue(message = "删除子规格时, 当前子规格系统编号code不能为空", groups = {UpdateValidation.class})
    public Boolean checkIntegralProductSpecCode() {
        return Boolean.FALSE.equals(valid) && StringUtils.isNotBlank(integralProductSpecCode);
    }
}
