package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.requestinfo.BasePageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * <p>
 * 积分商品
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商品")
public class IntegralProductPageReq extends BasePageReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("商品编码")
    private String productNo;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品分类系统code")
    private String productCategoryCode;

    @ApiModelProperty("商品类型 1优惠券 2实物")
    private Integer productType;

    @ApiModelProperty("状态 0下架 1上架")
    private Boolean state;

    @ApiModelProperty("是否热门 0否1是")
    private Boolean hotState;
}
