package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分商城退单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城退单")
public class IntegralMallRefundOrderCheckReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("退单系统编号code")
    @NotBlank(message = "退单系统编号code不能为空", groups = {UpdateValidation.class})
    private String integralMallRefundOrderCode;

    @ApiModelProperty("审核结果 0审核不通过  1审核通过")
    @NotBlank(message = "审核结果不能为空", groups = {UpdateValidation.class})
    private Boolean checkState;

    @ApiModelProperty("退单金额 单位元")
    private BigDecimal refundCashAmount;

    @ApiModelProperty("退回积分")
    private Integer refundIntegral;

    @ApiModelProperty("退回积分有效期天数")
    private Integer refundIntegralExpiredDays;

    @ApiModelProperty("退回积分过期时间")
    private LocalDateTime refundIntegralExpiredTime;

    @ApiModelProperty("审核备注")
    private String checkRemark;

    @ApiModelProperty("审核人系统编号code")
    @NotBlank(message = "审核人系统编号code不能为空", groups = {UpdateValidation.class})
    private String checkUserCode;

    @ApiModelProperty("审核人姓名")
    @NotBlank(message = "审核人姓名不能为空", groups = {UpdateValidation.class})
    private String checkUserName;

    @ApiModelProperty("更新人code")
    @NotBlank(message = "更新人code不能为空", groups = {UpdateValidation.class})
    private String modifiedUserCode;

    @ApiModelProperty("更新人姓名")
    @NotBlank(message = "更新人姓名不能为空", groups = {UpdateValidation.class})
    private String modifiedUserName;

}
