package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.enumutils.IntegralMallOrderStatusOperationTypeEnum;
import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 积分商城订单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城订单取消")
public class IntegralMallOrderCancelReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号")
    @NotBlank(message = "系统编号不能为空", groups = {CreateValidation.class})
    private String integralMallOrderCode;

    @ApiModelProperty("会员系统编号code")
    @NotBlank(message = "会员系统编号code不能为空", groups = {CreateValidation.class})
    private String mbrMemberCode;

    @ApiModelProperty("取消类型 1.用户取消 2.系统取消 3.后台取消")
    @NotNull(message = "取消类型不能为空", groups = {CreateValidation.class})
    private Integer cancelType;

    @ApiModelProperty("取消原因")
    private String cancelReason;

    @ApiModelProperty("更新人code")
    private String modifiedUserCode;

    @ApiModelProperty("更新人姓名")
    private String modifiedUserName;

    @AssertTrue(message = "取消原因不能为空", groups = {CreateValidation.class})
    public boolean checkCancelReasonOnlyUserCancel() {
        return IntegralMallOrderStatusOperationTypeEnum.USER_OPERATION.getType().equals(cancelType) && StringUtils.isNotBlank(cancelReason);
    }

    @AssertTrue(message = "取消原因不能为空", groups = {CreateValidation.class})
    public boolean checkCancelReasonOnlyCenterstageCancel() {
        return IntegralMallOrderStatusOperationTypeEnum.CENTERSTAGE_OPERATION.getType().equals(cancelType)
                && StringUtils.isNotBlank(modifiedUserCode) && StringUtils.isNotBlank(modifiedUserName) && StringUtils.isNotBlank(cancelReason);
    }
}
