package com.bizvane.airport.mall.feign.model.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class CouponDefVO implements Serializable {
    public static final long serialVersionUID = 1L;

    @ApiModelProperty("券编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券的面额")
    private BigDecimal money;

    @ApiModelProperty("券的折扣")
    private BigDecimal discount;

    @ApiModelProperty("有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天")
    private Integer validType;

    @ApiModelProperty("有效期开始时间")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    private LocalDateTime validDateEnd;

    @ApiModelProperty("有效天数")
    private Integer validDay;

    @ApiModelProperty("券模板图片")
    private String img;

    @ApiModelProperty("券状态（1已启用，0已停用）")
    private Boolean status;


}
