package com.bizvane.airport.mall.feign.service;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/wechatPayCallback")
@Api("积分商城回调管理")
public interface WechatPayCallbackFeign {

    @PostMapping("/payNotice")
    public ResponseData<String> payNotice(@RequestBody JSONObject transaction);

    @PostMapping("/refundNotice")
    public ResponseData<String> refundNotice(@RequestBody JSONObject refundNotification);
}
