package com.bizvane.airport.mall.feign.model.res;

import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class IntegralProductCategoryRes implements Serializable {

    @ApiModelProperty("系统code")
    private String integralProductCategoryCode;

    @ApiModelProperty("所属机构编号")
    @NotBlank(message = "所属机构编号不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String airportNoOrg;

    @NotBlank(message = "所属机构名称不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("商品分类名称")
    private String categoryName;

    @NotBlank(message = "所属机构编号不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("商品分类编号")
    private String categoryNo;

    @NotBlank(message = "分类描述不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("分类描述")
    private String categoryDesc;

    @ApiModelProperty("二维码URL")
    private String qrcodeUrl;

    @NotBlank(message = "是否展示在积分商城不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("是否展示在积分商城 0否1是")
    private Boolean displayInMall;

    @NotBlank(message = "排序不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("排序")
    private Integer sort;
}
