package com.bizvane.airport.mall.feign.model.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 积分订单明细
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分订单明细")
public class IntegralMallOrderDetailRes implements Serializable {
    public static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编码")
    private String integralMallOrderDetailCode;

    @ApiModelProperty("订单系统编码")
    private String integralMallOrderCode;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("积分商品编码")
    private String integralProductCode;

    @ApiModelProperty("积分商品sku系统编码")
    private String integralProductSkuCode;

    @ApiModelProperty("商品sku编号")
    private String productSkuNo;

    @ApiModelProperty("sku图片")
    private String productSkuImg;

    @ApiModelProperty("规格组合名称（以逗号分隔）")
    private String productSkuSpecNames;

    @ApiModelProperty("组合多规格code（以逗号分隔）")
    private String productSkuSpecCodes;

    @ApiModelProperty("规格描述")
    private String productSkuSpecDescription;

    @ApiModelProperty("商品积分价格")
    private Integer productIntegralPrice;

    @ApiModelProperty("商品现金价格，单位元")
    private BigDecimal productCashPrice;

    @ApiModelProperty("购买数量")
    private Integer saleQuantity;

}
