package com.bizvane.airport.mall.feign.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 积分实物商品 SKU 明细
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分实物商品 SKU 明细")
public class IntegralProductSkuReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编码")
    private String integralProductSkuCode;

    @ApiModelProperty("积分商品编码")
    private String integralProductCode;

    @ApiModelProperty("规格组合名称（以逗号分隔）")
    private String specNames;

    @ApiModelProperty("组合多规格code（以逗号分隔）")
    private String specCodes;

    @ApiModelProperty("规格描述")
    private String specDescription;

    @ApiModelProperty("SKU编号")
    private String skuNo;

    @ApiModelProperty("积分价格")
    private Integer integralPrice;

    @ApiModelProperty("现金价格，单位元")
    private BigDecimal cashPrice;

    @ApiModelProperty("库存数量")
    private Integer stockNum;

    @ApiModelProperty("剩余数量")
    private Integer remainNum;

    @ApiModelProperty("实兑数量")
    private Integer realExchangeNum;

    @ApiModelProperty("占单数量")
    private Integer holdOrderNum;

    @ApiModelProperty("是否启用：0 否，1 是")
    private Boolean enabled;

}
