package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.requestinfo.BasePageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分商城退单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城退单")
public class IntegralMallRefundOrderPageReq extends BasePageReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员卡号")
    private String mbrCardNo;

    @ApiModelProperty("会员手机号")
    private String mbrPhone;

    @ApiModelProperty("退单编号")
    private String refundOrderNo;

    @ApiModelProperty("商品编码")
    private String orderProductNo;

    @ApiModelProperty("商品名称")
    private String orderProductName;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    private Integer orderPayType;

    @ApiModelProperty("退单状态 1待审核 2待退款 3已退款 4已驳回")
    private Integer state;

    @ApiModelProperty("申请时间条件开始")
    private LocalDateTime startApplyDate;

    @ApiModelProperty("申请时间条件结束")
    private LocalDateTime endApplyDate;

    @ApiModelProperty("审核时间条件开始")
    private LocalDateTime startCheckDate;

    @ApiModelProperty("审核时间条件结束")
    private LocalDateTime endCheckDate;

}
