package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.requestinfo.BasePageReq;
import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分商城订单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城订单")
public class IntegralMallOrderPageReq extends BasePageReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("订单状态 0待付款 1已付款/待发货/待自提 2已发货（实物） 3已签收/已自提（实物）4已完成 5已退货 6已取消")
    private Integer state;

    @ApiModelProperty("会员卡号")
    private String mbrCardNo;

    @ApiModelProperty("会员手机号")
    private String mbrPhone;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    private Integer payType;

    @ApiModelProperty("商品编码")
    private String orderProductNo;

    @ApiModelProperty("商品名称")
    private String orderProductName;

    @ApiModelProperty("兑换时间开始条件")
    private LocalDateTime startExchangeTime;

    @ApiModelProperty("兑换时间结束条件")
    private LocalDateTime endExchangeTime;



}
