package com.bizvane.fitmentservice.models.Rpc;

import com.bizvane.fitmentservice.models.vo.AppletBrandMicroFitmentConfigVO;
import com.bizvane.fitmentservice.models.vo.AppletBrandMicroFitmentVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author zcc
 * @date 2021/9/22 17:09
 **/
@FeignClient(value = "${feign.client.fitment.name}", path = "${feign.client.fitment.path}/brandMicroFitmentRpc")
public interface AppletBrandMicroFitmentRpc {

    /**
     * 获取微页面装修详情
     *
     * @param appletBrandMicroFitmentId
     * @return
     */
    @GetMapping("/getById")
    public ResponseData<AppletBrandMicroFitmentVo> getById(@RequestParam(value = "appletBrandMicroFitmentId", required = true) Long appletBrandMicroFitmentId);

    /**
     * 根据品牌获取会员中心首页以及积分商城首页信息
     * @param brandId
     * @return
     */
    @GetMapping("/getMicroFitmentConfigByBrandId")
    ResponseData<AppletBrandMicroFitmentConfigVO> getMicroFitmentConfigByBrandId(@RequestParam(value = "brandId", required = true) Long brandId);

    /**
     * 根据品牌获取首页装修微页面
     * @param brandId
     * @return
     */
    @GetMapping("/getHomeMicroFitmentByBrandId")
    ResponseData<AppletBrandMicroFitmentVo> getHomeMicroFitmentByBrandId(@RequestParam(value = "brandId", required = true) Long brandId);

    /**
     * 根据品牌获取积分商城首页装修微页面
     * @param brandId
     * @return
     */
    @GetMapping("/getMallMicroFitmentByBrandId")
    ResponseData<AppletBrandMicroFitmentVo> getMallMicroFitmentByBrandId(@RequestParam(value = "brandId", required = true) Long brandId);
}
