package com.bizvane.fitmentservice.interfaces;


import com.bizvane.fitmentservice.models.enums.MicroFitmentTypeEnums;
import com.bizvane.fitmentservice.models.po.AppletBrandMicroFitmentPo;
import com.bizvane.fitmentservice.models.vo.AppletBrandMicroFitmentConfigVO;
import com.bizvane.fitmentservice.models.vo.AppletBrandMicroFitmentReqVo;
import com.bizvane.fitmentservice.models.vo.AppletBrandMicroFitmentVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author zcc
 * @date 2021/9/16 18:10
 **/
public interface AppletBrandMicroFitmentService {

    /**
     * 新增或者更新
     * @param appletBrandMicroFitmentPo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> addOrUpdate(AppletBrandMicroFitmentPo appletBrandMicroFitmentPo, SysAccountPO sysAccountPO);

    /**
     * 获取微页面装修列表分页
     * @param appletBrandMicroFitmentReqVo
     * @return
     */
    ResponseData<PageInfo<AppletBrandMicroFitmentVo>> getPageByVo(AppletBrandMicroFitmentReqVo appletBrandMicroFitmentReqVo);

    /**
     * 删除
     * @param appletBrandMicroFitmentId
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> deleteById(Long appletBrandMicroFitmentId, SysAccountPO sysAccountPO);

    /**
     * 获取详情
     * @param appletBrandMicroFitmentId
     * @return
     */
    ResponseData<AppletBrandMicroFitmentVo> getById(Long appletBrandMicroFitmentId);

    /**
     * 根据品牌获取会员中心首页以及积分商城首页信息
     * @param brandId
     * @return
     */
    ResponseData<AppletBrandMicroFitmentConfigVO> getMicroFitmentConfigByBrandId(Long brandId);

    /**
     * 根据品牌以及微页面类型获取最新的一条微页面装修
     * @param brandId
     * @param microFitmentTypeEnums
     * @return
     */
    ResponseData<AppletBrandMicroFitmentVo> getMicroFitmentByBrandIdAndType(Long brandId, MicroFitmentTypeEnums microFitmentTypeEnums);
}
