package com.bizvane.fitmentservice.interfaces;

import com.bizvane.fitmentservice.models.bo.AppletBrandFunctionBo;
import com.bizvane.fitmentservice.models.po.AppletFunctionPO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.google.gson.JsonObject;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 会员中心装修
 *
 * @author gs
 */
public interface MemberMadeService {
    /**
     * 根据品牌id获取功能菜单
     *
     * @param brandId,choice
     * @return
     */
    ResponseData<List<AppletBrandFunctionBo>> selectBrandFunction(Long brandId,Long appletTemplateId,SysAccountPO sysAccountPo);

    /**
     * 保存功能链接
     *
     * @param appletBrandFunctionBoList
     * @return
     */
    ResponseData insertUpdateImgFuntionMade(List<AppletBrandFunctionBo> appletBrandFunctionBoList, SysAccountPO sysAccountPo);

    /**
     * 查询所有功能菜单
     *
     * @param
     * @return
     */
    ResponseData<List<AppletBrandFunctionBo>> selectByPrimaryKey(Long brandId,String type,SysAccountPO sysAccountPo);

    /**
     * 新增或修改保存功能链接
     * @param appletBrandFunctionBoList
     * @return
     */
    ResponseData insertUpdateImgFuntionMadeNew(List<AppletBrandFunctionBo> appletBrandFunctionBoList, SysAccountPO sysAccountPo);

    /**
     * 验证参数
     * @param bo
     * @param sysAccountPo
     * @return
     */
    ResponseData<Map<String,Object>> funtionMadeVerifiedParam(AppletBrandFunctionBo bo, SysAccountPO sysAccountPo);

//    /**
//     * 修改功能链接
//     *
//     * @param bo
//     * @return
//     */

//    /**
//     * 删除功能链接
//     *
//     * @param appletFunctionPO
//     * @return
//     */

//    /**
//     * 增加功能链接
//     *
//     * @param appletFunctionPO
//     * @return
//     */


//    /**
//     * 上传图片
//     *
//     * @param bucket
//     * @return
//     */
}
