package com.bizvane.fitmentservice.models.Rpc;

import com.bizvane.fitmentservice.models.po.AppletResourcesPO;
import com.bizvane.fitmentservice.models.po.AppletVipCartPO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.fitment.name}", path = "${feign.client.fitment.path}/membershipCard")
public interface AppletResourcesRpc {

	@RequestMapping(value = "/getAppletResourcesInfo", method = RequestMethod.POST)
	ResponseData<AppletResourcesPO> getAppletResourcesPO(@RequestParam("modularCode") String modularCode,
			@RequestParam("brandId") Long brandId, @RequestParam("companyId") Long companyId);

	@RequestMapping(value = "/getAppletLevelCardList", method = RequestMethod.POST)
	ResponseData getAppletLevelCardList(@RequestParam("brandId") Long brandId);

}
