package com.bizvane.fitmentservice.models.Rpc;

import com.bizvane.fitmentservice.models.bo.AppletBrandFunctionBo;
import com.bizvane.fitmentservice.models.bo.AppletBrandFunctionRpcBo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.fitment.name}",path = "${feign.client.fitment.path}/memberMadeRpc")
public interface MenberMadeServiceRpc {
    /**
     * 根据品牌id获取功能菜单
     *
     * @param brandId
     * @return
     * */
    @RequestMapping(value = "/selectBrandFunctionRpc", method = RequestMethod.POST)
    ResponseData<List<AppletBrandFunctionRpcBo>> selectBrandFunctionRpc(@RequestParam("brandId") Long brandId,@RequestParam("choice") int choice);

    /**
     * 查询会员中心功能菜单
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/selectMemberCenterFuntionMake", method = RequestMethod.POST)
    ResponseData<AppletBrandFunctionBo> selectMemberCenterFuntionMake(@RequestParam("brandId") Long brandId);
}
