package com.bizvane.fitmentservice.models.Rpc;


import com.bizvane.fitmentservice.models.po.AppletVipCartPO;
import com.bizvane.fitmentservice.models.vo.AppletPayVipCardRequestVO;
import com.bizvane.fitmentservice.models.vo.AppletPayVipCardResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.fitment.name}", path = "${feign.client.fitment.path}/appletVipCard")
public interface AppletVipCardRpc {

    @PostMapping("/queryAppletPayVipCard")
    ResponseData<List<AppletPayVipCardResponseVO>> queryAppletPayVipCard(@RequestBody @Valid AppletPayVipCardRequestVO appletPayVipCardRequestVO);

    @PostMapping("/getAppletVipCardList")
    public ResponseData<List<AppletVipCartPO>> getAppletVipCardList(@RequestParam("sysBrandId") Long sysBrandId);
}
