/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.invoker.impl;

import com.bizvane.dynamicdatasource.call.invoker.Invoker;
import com.bizvane.dynamicdatasource.call.registry.RouteRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DiscoveryInvoker
implements Invoker {
    @Autowired
    private LoadBalancerClient loadBalancer;

    @Override
    public boolean supports(String type) {
        return "DISCOVERY".equals(type);
    }

    @Override
    public <T> T invoke(RouteRepository.Rout rout, String api, Object request, Class<T> responseType) {
        ServiceInstance instance = this.loadBalancer.choose(rout.getServiceName());
        String url = instance.getUri() + api;
        return (T)new RestTemplate().postForObject(url, request, responseType, new Object[0]);
    }
}

