package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.AdvertisementSpaceRequestVO;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 *
 * @author ljc
 * @date 2020-12-24
 */
@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/advertisementSpace")
@Api(value = "怀仁广告位相关接口",tags = {"广告位"})
public interface AdvertisementSpaceServiceFeign {

    /**
     * 提供给小程序获取广告位信息
     * @param vo
     * @return
     */
    @PostMapping(value = "/getAdvertisementSpace")
    ResponseData<AdvertisementSpaceResponseVO> getAdvertisementSpace(@RequestBody AdvertisementSpaceRequestVO vo);



}
