package com.bizvane.customized.facade.enums.ur.members;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum QuestionnaireTempCheckStatusEnum {
    COMMON(1, "正常"),
    NOT_ENABLED(2, "未启用"),
    NOT_EXIST(3,"不存在"),
    EXPIRED(4,"已失效"),
    ;

    private Integer code;
    private String msg;

    public static String getMsg(Integer code){
        for (QuestionnaireTempCheckStatusEnum c: QuestionnaireTempCheckStatusEnum.values()){
            if(c.getCode().equals(code)){
                return c.getMsg();
            }
        }
        return null;
    }

}
