package com.bizvane.customized.facade.enums;

public enum AdvertisementSpaceEnum {
    /**
     * Banner区域
     */
    BANNER(1, "Banner"),
    /**
     * 本月福利专区区域
     */
    BENEFITS(2, "本月福利专区"),
    /**
     * 超值好券区域
     */
    COUPON(3,"超值好券"),
    /**
     * 怀仁网上商城区域
     */
    MALL(4,"怀仁网上商城"),
    /**
     * 积分商城区域
     */
    POINTSMALL(5,"积分商城"),

    /**
     * 查看更多
     */
    VIEW_MORE(0,"查看更多"),
    /**
     * 每行图片个数 一个
     */
    IMAGE_SHARE_ONE(1,"并列一个"),

    /**
     * 每行图片个数 二个
     */
    IMAGE_SHARE_TWO(2,"并列两个"),
    /**
     * 每行图片个数 三个
     */
    IMAGE_SHARE_THREE(3,"并列三个");


    private Integer code;
    private String status;

    AdvertisementSpaceEnum(int code , String status) {
        this.code = code;
        this.status = status;
    }

    public Integer getCode() {
        return code;
    }

    public String getStatus() {
        return status;
    }
}
