package com.bizvane.customized.facade.interfaces;

import com.bizvane.connectorservice.entity.hqt.HqSmallAmountStorageRequestVO;
import com.bizvane.connectorservice.entity.hqt.HqSmallAmountStorageResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 *
 * @Author yuantq
 * @Date 2023/12/18
 * @Description 红蜻蜓小额储值相关接口
 * @Version 1.0
 */
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/hq/smallAmountStorage")
public interface CusHqSmallAmountStorageServiceFeign {


    /**
     * 获取会员小额充值次数
     */
    @PostMapping(value = "/getMemberRechargeTimes")
    ResponseData<HqSmallAmountStorageResponseVO> getMemberRechargeTimes(@RequestBody HqSmallAmountStorageRequestVO requestVO);

}
