package com.bizvane.customized.facade.models.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lijunke
 */
@Data
public class CusSyncWMOrderDetailVo implements Serializable {

    /**
     * 子单据编号
     */
    @JSONField(name = "detail_record_code")
    private String detailRecordCode;

    /**
     * 商品代码
     */
    @JSONField(name = "goods_code")
    private String goodsCode;

    /**
     * 颜色代码
     */
    @JSONField(name = "color_code")
    private String colorCode;

    /**
     * 尺码代码
     */
    @JSONField(name = "size_code")
    private String sizeCode;

    /**
     * 吊牌价
     */
    @JSONField(name = "refer_price")
    private BigDecimal referPrice;

    /**
     * 售价
     */
    private BigDecimal price;

    /**
     * 折扣
     */
    private BigDecimal rebate;

    /**
     * 实付金额，不包含用券、用积分部分
     */
    private BigDecimal money;

    /**
     * 数量
     */
    private Integer num;

    /**
     * 实际售价（例如商品售价100，如此单为售后单，实际售价价格应为-100）
     */
    @JSONField(name = "real_price")
    private BigDecimal realPrice;

    /**
     * 来源 1:erp 6：pos 30：微购物 31：微信
     */
    private String source;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否启用1:启用:0停用(合并顾客引起数据变化)
     */
    @JSONField(name = "is_enable")
    private Integer isEnable;

}