package com.bizvane.customized.facade.models.vo.ur;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 适用门店
 * 全部适用、部分适用
 * 门店名称
 * 如是全部适用，需要返回店铺状态为“开店”的全部门店
 * 门店code
 * 门店地址
 * 门店电话
 * 经纬度
 * CRM侧存在部分门店无经纬度信息
 */
@Getter
@Setter
public class CusUrRechargeCardRuleStoreVO implements Serializable {


    @ApiModelProperty(value = "店铺")
    private List<StoreVO> storeList;

    @ApiModelProperty(value = "0：全部适用、1：部分适用")
    private Integer isStoreLimit;


    @Getter
    @Setter
    public static  class StoreVO implements Serializable {
        private String storeId;
        private String storeName;
        private String storePhone;
        private String detailedAddress;
        private String lng;
        private String lat;
    }

}