package com.bizvane.customized.facade.models.vo.shininghouse;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author yy
 * @create 2019-03-08 11:12
 */
@Data
public class IntegralGoods implements Serializable{

    private Integer id;

    /**
     * 商户ID
     */
    private Integer merchantId;


    private String goodsNo;


    private String goodsName;


    private Boolean shelf;


    private String classifyId;


    private String coverImg;


    private String bannerImgPaths;



    private Boolean hot;

    private Integer sort;

    private String goodsDetails;



    private Long price;


    private Date upperShelfTime;


    private Date lowerShelfTime;


    private Integer restrictedNum;

    private Integer actualSales;
    /**
     * 配送方式 0寄货到家 1顾客自提 2顾客自选
     *
     * **/
    private String distributionMode;


    private String exchangeInstructions;



    private Date gmtCreate;


    private Date gmtModified;


    private Boolean valid;

    /**
     * 0:全部   1：限制门店白名单  2：限制会员等级  3:限制门店和会员
     */
    private Integer memberScope;

    private String storeWhiteList;

    private String memberLevelNames;

    /**
     * sku信息
     */
    private List<IntegralGoodsSku> skus;


    /**
     * 商品分类列表
     */
    private List<IntegralClassify> classifyList;


    /**
     * 总库存
     */
    private Integer totalStock;


    private String upperShelfTimeStr;

    /**
     * 上下架状态显示名称
     */
    private String shelfName;


}
