/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.facade.utils;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import jodd.util.Base64;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqbSignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SqbSignatureUtil.class);
    private static final String SIGNATURE_ALGORITHM = "SHA256WithRSA";
    private static final String KEY_ALGORITHM = "RSA";

    public static boolean validateSign(String data, String sign, String publicKey) {
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            PublicKey localPublicKey = SqbSignatureUtil.getPublicKeyFromX509(KEY_ALGORITHM, publicKey);
            signature.initVerify(localPublicKey);
            signature.update(data.getBytes());
            byte[] bytesSign = Base64.decode((String)sign);
            return signature.verify(bytesSign);
        }
        catch (Exception e) {
            log.error("validateSign error", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decode((String)publicKey)));
    }
}

