package com.bizvane.customized.facade.enums.mj;


public enum GjftCardOperationTypEnum {
    //变动类型 0开卡 1充值 2消费 3消费退 4过期调整 5换卡转存 6退款 7积分变现 8充值调整
    OPENCARD(0, "开卡"),
    RECHARGE(1, "充值"),
    CONSUMPTION(2, "充值"),
    DRAWBACK (3, "消费"),
    EXPIRE(4, "过期调整"),
    DEPOSIT_TRANSFER(5, "换卡转存"),
    REFUND(6, "退款"),
    REALIZATION(7, "积分变现"),
    RECHARGE_ADJUST(8, "充值调整");


    private Integer code;
    private String message;



    GjftCardOperationTypEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static GjftCardOperationTypEnum getGjftCardOperationTypEnum(Integer code){
        for (GjftCardOperationTypEnum value : GjftCardOperationTypEnum.values()) {
            if(value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }
}
