package com.bizvane.customized.facade.models.vo.ur;

import lombok.Data;

import java.util.List;

/**
 * @author yuantq
 * @date 2022/1/10
 */
@Data
public class OrderSyncModel {

    /**
     * 商户品牌编号，由喔噻进行分配
     */
    private String brand_code;

    /**
     * 商户门店编号
     */
    private String store_sn;

    /**
     * 	商户门店名称
     */
    private String store_name;

    /**
     * 商户款台编号，如果商户系统没有该参数值，请设置为 0
     */
    private String workstation_sn;

    /**
     * 商户订单号
     */
    private String check_sn;

    /**
     * 	订单销售时间，格式为"yyyyMMddHHmmss"
     */
    private String sales_time;

    /**
     * 订单金额，单位是分，退货时金额传负数
     */
    private String amount;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 操作员
     */
    private String operator;

    /**
     * 顾客信息
     */
    private String customer;

    /**
     * 商品明细
     */
    private List<ItemModel> items;

    /**
     * 订单详情
     */
    private List<TenderModel> tenders;

}
