package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.ur.RechargeInvoiceModel;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author yuantq
 * @date 2022/1/7
 */
@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/ur/rechargeInvoiceRpc")
@Api(value = "储蓄卡充值开票相关接口",tags = {"储蓄卡充值开票"})
public interface RechargeInvoiceServiceFeign {

    /**
     * 申请开发票
     * @param rechargeInvoiceModel
     * @return
     */
    @PostMapping("/invoiceApply")
    ResponseData invoiceApply(@RequestBody RechargeInvoiceModel rechargeInvoiceModel);

    /**
     * 查看发票
     * @param rechargeInvoiceModel
     * @return
     */
    @PostMapping("/queryApply")
    ResponseData queryApply(@RequestBody RechargeInvoiceModel rechargeInvoiceModel);

}
